﻿var timeout = 5;
var draggedBox = null;
var offset = null;

document.onmouseup = mouseUp;
document.onmousemove = mouseMove;

function mousePos(evt)
{
  evt = evt || window.event;

  if(evt.pageX){
    return {x:evt.pageX, y:evt.pageY};
  }
  else if(evt.clientX){
    return{
      x:evt.clientX + document.body.scrollLeft + document.body.clientLeft,
      y:evt.clientY + document.body.scrollTop  - document.body.clientTop
    };
  }
  else{
    return {x:0, y:0};
  }
}

function startDrag(obj)
{
  if(!obj) return;
  draggedBox = obj;
  xOff = 0;
  yOff = 0;
  while(obj.offsetParent){
    xOff += obj.offsetLeft;
    yOff += obj.offsetTop;
    obj = obj.offsetParent;
  }
  
  obj.onmousedown = function(evt)
  {
    coords = mousePos(evt);
    xOff = coords.x - xOff;
    yOff = coords.y - yOff; 
    offset = {x:xOff, y:yOff};
  }
}

function mouseUp(evt)
{
  draggedBox = null;
}

function mouseMove(evt)
{
  coords = mousePos(evt);

  if(draggedBox){
    draggedBox.style.position = "absolute";
    draggedBox.style.top = (coords.y - offset.y) + "px";
    draggedBox.style.left = (coords.x - offset.x) + "px";
    return false;
  }
}

function startRequest(param)
{
  id = (new Date()).getTime();
  url = "http://localhost/adv.php?id" + id;
  startGETRequest(url, onComplete, onEnd);
}

function onEnd()
{
}

function onComplete(text, xml)
{
  var advBox = document.getElementById("advBox");
  advBox.innerHTML = text;
  setTimeout("startRequest()", timeout * 1000);
}